package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor;

import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.AutoLoginInterceptorHandler;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 开放平台拦截管理器
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
public class AutoLoginInterceptorHandlerManager {

    @Autowired(required = false)
    List<AutoLoginInterceptorHandler> interceptorHandlerList;

    public Boolean doHandler(Object handler) throws Exception {
        if (interceptorHandlerList == null || interceptorHandlerList.isEmpty()) {
            return true;
        }
        for (AutoLoginInterceptorHandler interceptorHandler : interceptorHandlerList) {
            if (!interceptorHandler.accept(handler)) {
                return false;
            }
        }
        return true;
    }

}
