/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.sdk.handler;

import cn.com.duiba.cloud.duiba.openapi.web.api.config.OpenRequest;
import cn.com.duiba.cloud.duiba.openapi.web.api.dto.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.sdk.annotation.TenantAppOverdueAnnotation;
import cn.com.duiba.cloud.manage.sdk.config.ToCManageServiceConfigProperties;
import cn.com.duiba.cloud.manage.sdk.handler.ToCManageServiceHandler;
import cn.com.duiba.cloud.manage.sdk.utils.ToCManageServiceRequestTool;
import cn.com.duiba.cloud.manage.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

@EnableConfigurationProperties(value={ToCManageServiceConfigProperties.class})
public class TenantAppOverdueHandler
implements ToCManageServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantAppOverdueHandler.class);
    @Resource
    private ToCManageServiceConfigProperties properties;
    @Resource
    private CommonVerification commonVerification;

    @Override
    public Boolean accept(Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            TenantAppOverdueAnnotation tenantAppOverdueAnnotation = (TenantAppOverdueAnnotation)AnnotationUtils.getAnnotation((Method)method.getMethod(), TenantAppOverdueAnnotation.class);
            if (Objects.isNull(tenantAppOverdueAnnotation)) {
                return Boolean.TRUE;
            }
            String tenantAppId = ToCManageServiceRequestTool.getRequest().getParameter(tenantAppOverdueAnnotation.fieldVerity());
            if (StringUtils.isBlank((String)tenantAppId)) {
                ConsumerCookieDTO consumerCookieDTO = OpenRequest.getConsumerInfo();
                AssertUtil.isNotNull((Object)consumerCookieDTO, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull((Object)tenantAppId, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
            Boolean verifyTenantAppOverdue = this.commonVerification.verifyTenantAppOverdue(Long.parseLong(tenantAppId));
            if (verifyTenantAppOverdue.booleanValue()) {
                return Boolean.TRUE;
            }
            log.error("tenantApp:{} Overdue:{} ", (Object)tenantAppId, (Object)verifyTenantAppOverdue);
            ToCManageServiceRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
            JsonResult result = JsonResult.fail((String)ErrorCode.TENANT_APP_OVERDUE.getCode(), (String)ErrorCode.TENANT_APP_OVERDUE.getMsg());
            ToCManageServiceRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 10;
    }
}

