/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtNotCheckTenantApp;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteTenantHasAppParam;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtCustomerService;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class TenantAppHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantAppHandler.class);
    @Resource
    private RemoteMgtCustomerService remoteMgtCustomerService;

    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            MgtNotCheckTenantApp rights = (MgtNotCheckTenantApp)AnnotationUtils.findAnnotation((Method)method.getMethod(), MgtNotCheckTenantApp.class);
            Long tenantAppId = LoginUtil.getTenantAppIdOrNull();
            if (Objects.isNull(tenantAppId) || Objects.nonNull(rights)) {
                return Boolean.TRUE;
            }
            try {
                Long tenantId = null;
                Long staffId = null;
                Boolean valid = false;
                try {
                    tenantId = LoginUtil.getTenantId();
                    staffId = LoginUtil.getStaffId();
                    RemoteTenantHasAppParam remoteParam = new RemoteTenantHasAppParam();
                    remoteParam.setTenantId(tenantId);
                    remoteParam.setTenantAppId(tenantAppId);
                    valid = this.remoteMgtCustomerService.tenantHasApp(remoteParam);
                }
                catch (BizException e) {
                    log.error("query tenantAppId error ! tenantId:{},tenantAppId:{},staffId:{},errCode:{},errMsg:{}", new Object[]{tenantId, tenantAppId, staffId, e.getCode(), e.getMessage()});
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)e.getCode(), (String)e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return Boolean.FALSE;
                }
                if (!valid.booleanValue()) {
                    log.warn("tenantAppId not valid ! tenantId:{},tenantAppId:{},staffId:{}", new Object[]{tenantId, tenantAppId, staffId});
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)ErrorCode.APP_INFO_INVALID.getCode(), (String)ErrorCode.APP_INFO_INVALID.getMsg());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return Boolean.FALSE;
                }
            }
            catch (IOException e) {
                throw new SsoRunTimeException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 25;
    }
}

