package cn.com.duiba.cloud.manage.service.sdk.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 权益注解
 * 1. 如果权益content有值，请把需要接受content内容的参数放在方法的首个参数上
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/8
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
@Inherited
public @interface MgtRights {

    /**
     * 权限名称
     * @return
     */
    String name();

    /**
     * 权限code
     * @return
     */
    String code();

    /**
     * 无权限的提示信息
     * @return
     */
    String message() default "企业未开通此权益";


}
