package cn.com.duiba.cloud.manage.service.sdk.handler.verification;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.model.VerifyRightsRes;

/**
 * 权限权益校验通用接口
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/16
 */
public interface PermissionVerification {

    /**
     * 校验权限
     * @param authCode
     * @return
     * @throws BizException
     */
    Boolean verifyAuthority(Long tenantId, Long tenantAppId, Long staffId, String authCode) throws BizException;

    /**
     * 校验权益
     * @param rightsCode
     * @param tenantId
     * @return
     * @throws BizException
     */
    VerifyRightsRes verifyRights(Long tenantId, Long tenantAppId, String rightsCode) throws BizException;

}
