package cn.com.duiba.cloud.manage.service.sdk.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteCachedStaffInfoParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteTenantHasAppParam;

/**
 * 用户服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/1/12
 */
@AdvancedFeignClient
public interface RemoteMgtCustomerService {

    /**
     * 校验缓存中是否还有该员工在当前租户下的信息
     * @param remoteParam
     * @return
     */
    public String cachedStaffInfo(RemoteCachedStaffInfoParam remoteParam);

    /**
     * 校验应用是否属于当前应用 - 为了避免篡改参数
     * @param remoteParam
     * @return
     */
    public Boolean tenantHasApp(RemoteTenantHasAppParam remoteParam) throws BizException;

}
