package cn.com.duiba.cloud.manage.service.sdk.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkStaffAuthorityDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkTenantRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.VerifyRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteQueryStaffAuthorityParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteQueryTenantAppRightsParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteVerifyAuthorityParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteVerifyRightsParam;

/**
 * 远程的管理后台权限服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/16
 */
@AdvancedFeignClient
public interface RemoteMgtPermissionService {

    /**
     * 校验权限
     * @param remoteParam
     * @return
     * @throws BizException
     */
    public Boolean verifyAuthority(RemoteVerifyAuthorityParam remoteParam) throws BizException;

    /**
     * 权益校验
     * @param remoteParam
     * @return
     * @throws BizException
     */
    public VerifyRightsDTO verifyRights(RemoteVerifyRightsParam remoteParam) throws BizException;

    /**
     * 查询租户权益
     * @param param
     * @return
     * @throws BizException
     */
    public SdkTenantRightsDTO queryTenantAppRights(RemoteQueryTenantAppRightsParam param) throws BizException;

    /**
     * 查询员工权限
     * @param param
     * @return
     * @throws BizException
     */
    public SdkStaffAuthorityDTO queryStaffAuthority(RemoteQueryStaffAuthorityParam param) throws BizException;

}
