/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.controller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.RedisKeyEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppCookieQueryParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.app.RemoteAppService;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.annotation.CanAccess;
import cn.com.duiba.cloud.single.sign.on.contract.tool.CookieUtil;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"appClient"})
public class AppClientController {
    private static final Logger log = LoggerFactory.getLogger(AppClientController.class);
    @Resource
    private RemoteAppService remoteAppService;

    @RequestMapping(value={"index"})
    public String index(@RequestParam Long innerUserId, @RequestParam Long tenantId, @RequestParam(required=false) String redirect) throws BizException {
        return this.handleIndex(innerUserId, tenantId, redirect);
    }

    @RequestMapping(value={"erpIndex"})
    @CanAccess
    public String erpIndex(@RequestParam Long innerUserId, @RequestParam Long tenantId, @RequestParam(required=false) String redirect) throws BizException {
        return this.handleIndex(innerUserId, tenantId, redirect);
    }

    private String handleIndex(Long innerUserId, Long tenantId, String redirect) throws BizException {
        RemoteAppCookieQueryParam param = new RemoteAppCookieQueryParam();
        String key = RedisKeyEnum.getRedisKey((RedisKeyEnum)RedisKeyEnum.APP_COOKIE_INFO, (Object[])new Object[]{innerUserId, tenantId});
        param.setKey(key);
        List cookieList = this.remoteAppService.getAppCookieInfo(param);
        if (CollectionUtils.isEmpty((Collection)cookieList)) {
            throw new BizException("\u65e0\u6548\u7684cookie\u4fe1\u606f");
        }
        for (Cookie cookie : cookieList) {
            Cookie newCookie = CookieUtil.createCookie((String)cookie.getName(), (String)cookie.getValue(), (Integer)cookie.getMaxAge());
            SsoRequestTool.addCookie((Cookie)newCookie);
        }
        return "redirect:" + redirect;
    }
}

