/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler.verification.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.AuthRightsStateEnum;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.model.VerifyRightsRes;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.SdkTenantRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.VerifyRightsDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteQueryTenantAppRightsParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteVerifyAuthorityParam;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteVerifyRightsParam;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtPermissionService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.stream.Collectors;

public class RemotePermissionVerification
implements PermissionVerification {
    private final RemoteMgtPermissionService remoteMgtPermissionService;

    public RemotePermissionVerification(RemoteMgtPermissionService service) {
        this.remoteMgtPermissionService = service;
    }

    @Override
    public Boolean verifyAuthority(Long tenantId, Long tenantAppId, Long staffId, String authCode) throws BizException {
        RemoteVerifyAuthorityParam remoteParam = new RemoteVerifyAuthorityParam();
        remoteParam.setAuthCode(authCode);
        remoteParam.setTenantId(tenantId);
        remoteParam.setStaffId(staffId);
        remoteParam.setTenantAppId(tenantAppId);
        return this.remoteMgtPermissionService.verifyAuthority(remoteParam);
    }

    @Override
    public VerifyRightsRes verifyRights(Long tenantId, Long tenantAppId, String rightsCode) throws BizException {
        RemoteVerifyRightsParam remoteParam = new RemoteVerifyRightsParam();
        remoteParam.setRightsCode(rightsCode);
        remoteParam.setTenantAppId(tenantAppId);
        remoteParam.setTenantId(tenantId);
        VerifyRightsDTO dto = this.remoteMgtPermissionService.verifyRights(remoteParam);
        return (VerifyRightsRes)BeanUtils.copy((Object)dto, VerifyRightsRes.class);
    }

    @Override
    public Boolean verifyRightsField(Long tenantId, Long tenantAppId, Object object) throws BizException {
        RemoteQueryTenantAppRightsParam remoteParam = new RemoteQueryTenantAppRightsParam();
        remoteParam.setTenantAppId(tenantAppId);
        remoteParam.setTenantId(tenantId);
        SdkTenantRightsDTO sdkTenantRightsDTO = this.remoteMgtPermissionService.queryTenantAppRights(remoteParam);
        List rightsCodeList = sdkTenantRightsDTO.getRightsList().stream().filter(o -> AuthRightsStateEnum.ENABLE.getCode().equals(o.getAvailableState())).map(SdkRightsDTO::getRightsCode).collect(Collectors.toList());
        return rightsCodeList.contains(object);
    }
}

