/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppSecretQueryParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.app.RemoteAppService;
import cn.com.duiba.cloud.manage.service.api.service.SignService;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import javax.annotation.Resource;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SignServiceImpl
implements SignService {
    @Resource
    private RemoteAppService remoteAppService;

    @Override
    @Cacheable(value={"appSecret"})
    public String getAppSecret(String appKey) throws BizException {
        System.out.println("\u6211\u5fc5\u987b\u6267\u884c\u7684------------------");
        AppDetailDTO appDetailDTO = this.getAppDetail(appKey);
        AssertUtil.isNotNull((Object)appDetailDTO, (ErrorCode)ErrorCode.APP_NOT_EXISTS, (Object[])new Object[0]);
        AssertUtil.isNotBlank((String)appDetailDTO.getAppSecret(), (ErrorCode)ErrorCode.APP_NOT_EXISTS, (Object[])new Object[0]);
        return appDetailDTO.getAppSecret();
    }

    private AppDetailDTO getAppDetail(String appKey) throws BizException {
        System.out.println("\u5047\u5982\u6211\u6267\u884c\uff0c\u5c31\u662f\u7f13\u5b58\u6ca1\u751f\u6548------------------");
        RemoteAppSecretQueryParam param = new RemoteAppSecretQueryParam();
        param.setAppKey(appKey);
        AppDetailDTO appDTO = this.remoteAppService.getAppSecret(param);
        return appDTO;
    }
}

