/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.service.SignService;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SignUtil
implements ApplicationContextAware {
    private static SignService signService;

    public static String sign(Map<String, Object> map, String appKey) throws BizException {
        String appSecret = signService.getAppSecret(appKey);
        return SignUtil.signWithAppSecret(map, appSecret);
    }

    public static boolean signCheck(Map<String, Object> map, String appKey, String sign) throws BizException {
        return sign.equals(SignUtil.sign(map, appKey));
    }

    public static String signWithAppSecret(Map<String, Object> map, String appSecret) throws BizException {
        String data = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        data = data + appSecret;
        return DigestUtil.md5Hex((String)data).toUpperCase();
    }

    public static boolean signWithAppSecretCheck(Map<String, Object> map, String appSecret, String sign) throws BizException {
        return sign.equals(SignUtil.signWithAppSecret(map, appSecret));
    }

    public static String encrypt(String data, String appKey) throws BizException {
        if (StringUtils.isBlank((CharSequence)appKey)) {
            throw new NullPointerException("appKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String appSecret = signService.getAppSecret(appKey);
        return SignUtil.encryptWithAppSecret(data, appSecret);
    }

    public static String encryptWithAppSecret(String data, String appSecret) {
        return SecurityUtils.encode2StringByBase64((byte[])SecurityUtils.encodeByAes((String)data, (String)appSecret));
    }

    public static String decrypt(String data, String appKey) throws BizException {
        if (StringUtils.isBlank((CharSequence)appKey)) {
            throw new NullPointerException("appKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String appSecret = signService.getAppSecret(appKey);
        return SignUtil.decryptWithAppSecret(data, appSecret);
    }

    public static String decryptWithAppSecret(String data, String appSecret) {
        return new String(SecurityUtils.decodeByAes((byte[])SecurityUtils.decodeBase64((String)data), (String)appSecret), StandardCharsets.UTF_8);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        signService = (SignService)applicationContext.getBean(SignService.class);
    }
}

