/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.measurement.client;

import cn.com.duiba.cloud.measurement.client.exception.MeasureException;
import cn.com.duiba.cloud.measurement.client.remoteserver.RemoteMeasureTransactionService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(MeasureTransactionManager.class);
    private final ThreadLocal<String> transactionIdThreadLocal = new ThreadLocal();
    @Resource
    private RemoteMeasureTransactionService remoteMeasureTransactionService;

    protected String getTransactionId() {
        return this.transactionIdThreadLocal.get();
    }

    public void beginTransaction() {
        String transactionId = this.remoteMeasureTransactionService.applyForTransactionId();
        this.transactionIdThreadLocal.set(transactionId);
    }

    public void commit() {
        String transactionId = this.transactionIdThreadLocal.get();
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            throw new MeasureException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u5904\u4e8e\u8ba1\u91cf\u4e8b\u52a1\u4e2d");
        }
        this.remoteMeasureTransactionService.commit(transactionId);
        this.transactionIdThreadLocal.remove();
    }

    public void rollback() {
        String transactionId = this.transactionIdThreadLocal.get();
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            throw new MeasureException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u5904\u4e8e\u8ba1\u91cf\u4e8b\u52a1\u4e2d");
        }
        try {
            this.remoteMeasureTransactionService.rollback(transactionId);
        }
        catch (Exception e) {
            log.error("\u56de\u6eda\u5931\u8d25", (Throwable)e);
        }
        this.transactionIdThreadLocal.remove();
    }
}

