/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.measurement.client.service;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.measurement.client.MeasureClient;
import cn.com.duiba.cloud.measurement.client.configuration.MeasurementConfig;
import cn.com.duiba.cloud.measurement.client.configuration.MeasurementProperties;
import cn.com.duiba.cloud.measurement.client.domain.MeasureTypeDto;
import cn.com.duiba.cloud.measurement.client.exception.MeasureException;
import cn.com.duiba.cloud.measurement.client.remoteserver.RemoteMeasureTypeService;
import cn.com.duiba.cloud.measurement.client.service.MeasureClientEmpowerManager;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class MeasureClientManager {
    @Resource
    private RemoteMeasureTypeService remoteMeasureTypeService;
    @Resource
    private MeasurementProperties measurementProperties;
    @Resource
    private MeasureClientEmpowerManager measureClientEmpowerManager;
    @Resource
    private ApplicationContext applicationContext;
    @Value(value="${spring.application.name}")
    private String appId;
    private final LoadingCache<String, MeasureClient> measureClientCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, MeasureClient>(){

        public MeasureClient load(@NonNull String measureType) {
            MeasurementConfig config = MeasureClientManager.this.measurementProperties.getTypes().get(measureType);
            if (Objects.isNull(config) || !config.getEnable().booleanValue()) {
                throw new MeasureException("\u672a\u914d\u7f6e\u6216\u8005\u672a\u5f00\u542f\u8ba1\u91cf\u7c7b\u578b\u3010" + measureType + "\u3011");
            }
            MeasureClientManager.this.measureClientEmpowerManager.checkEmpower(measureType);
            MeasureClient measureClient = (MeasureClient)MeasureClientManager.this.applicationContext.getBean(MeasureClient.class);
            measureClient.setMeasureType(measureType);
            return measureClient;
        }
    });

    @EventListener(value={MainContextRefreshedEvent.class})
    public void init() throws BizException {
        ArrayList types = Lists.newArrayList();
        for (String measureType : this.measurementProperties.getTypes().keySet()) {
            MeasurementConfig config = this.measurementProperties.getTypes().get(measureType);
            if (!config.getEnable().booleanValue()) continue;
            MeasureTypeDto dto = new MeasureTypeDto();
            dto.setKey(measureType);
            types.add(dto);
        }
        if (types.isEmpty()) {
            return;
        }
        Set<String> initMeasureTypes = this.remoteMeasureTypeService.initMeasureTypes(this.appId, types);
        this.measureClientEmpowerManager.init(initMeasureTypes);
    }

    public MeasureClient getMeasureClient(String measureType) {
        return (MeasureClient)this.measureClientCache.get((Object)measureType);
    }
}

