/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.measurement.client;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.measurement.client.MeasureTransactionManager;
import cn.com.duiba.cloud.measurement.client.domain.MeasureChangeResultDto;
import cn.com.duiba.cloud.measurement.client.domain.MeasureDto;
import cn.com.duiba.cloud.measurement.client.domain.params.ChangeMeasureParams;
import cn.com.duiba.cloud.measurement.client.domain.params.ChangeMultiMeasureParams;
import cn.com.duiba.cloud.measurement.client.remoteserver.RemoteMeasureService;
import cn.com.duiba.cloud.measurement.client.service.CleanMeasureCallback;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureClient {
    private static final Logger log = LoggerFactory.getLogger(MeasureClient.class);
    private String measureType;
    @Resource
    private MeasureTransactionManager measureTransactionManager;
    @Resource
    private RemoteMeasureService remoteMeasureService;

    public void setMeasureType(String measureType) {
        this.measureType = measureType;
    }

    public MeasureChangeResultDto changeMeasure(String measureId, String bizNo, Long delta) throws BizException {
        return this.changeMeasure(measureId, bizNo, delta, false);
    }

    public MeasureChangeResultDto changeMeasure(String measureId, String bizNo, Long delta, Boolean isBack) throws BizException {
        ChangeMeasureParams params = new ChangeMeasureParams();
        params.setMeasureId(measureId);
        params.setBack(isBack);
        params.setBizNo(bizNo);
        params.setTransactionId(this.measureTransactionManager.getTransactionId());
        params.setChangeValue(delta);
        return this.remoteMeasureService.changeMeasure(this.measureType, params);
    }

    public Map<String, MeasureChangeResultDto> changeMultiMeasure(List<String> measureIds, String bizNo, Long totalDelta) throws BizException {
        if (measureIds.isEmpty()) {
            return Collections.emptyMap();
        }
        ChangeMultiMeasureParams params = new ChangeMultiMeasureParams();
        params.setMeasureIds(measureIds);
        params.setBizNo(bizNo);
        params.setChangeValue(totalDelta);
        params.setTransactionId(this.measureTransactionManager.getTransactionId());
        return this.remoteMeasureService.changeMultiMeasure(this.measureType, params);
    }

    public void cleanMeasure(String measureId, CleanMeasureCallback callback) throws BizException {
        MeasureDto result = this.remoteMeasureService.clearMeasure(this.measureType, measureId);
        try {
            if (Objects.nonNull(callback)) {
                callback.call(result);
            }
            this.remoteMeasureService.ackClearMeasure(this.measureType, measureId);
        }
        catch (Exception e) {
            log.error("\u6e05\u7b97\u5931\u8d25", (Throwable)e);
            this.remoteMeasureService.recoverMeasure(this.measureType, measureId);
        }
    }
}

