/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.stream.delay;

import cn.com.duiba.cloud.stream.delay.DelayMessageOperatorHandler;
import cn.com.duiba.cloud.stream.delay.handler.RocketmqMessageOperatorHandler;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.message.Message;

public class DelayMessageOperator {
    private static Map<Class, Class<? extends DelayMessageOperatorHandler>> handlerMap = Maps.newConcurrentMap();
    private Object message;
    private DelayMessageOperatorHandler handler;

    private DelayMessageOperator() {
    }

    public static DelayMessageOperator of(Object message) {
        Class<? extends DelayMessageOperatorHandler> handlerClass = handlerMap.get(message.getClass());
        if (handlerClass == null) {
            throw new IllegalArgumentException("\u6ca1\u6709" + message.getClass().getSimpleName() + "\u5bf9\u5e94\u7684\u64cd\u4f5c\u9002\u914d\u5668");
        }
        DelayMessageOperator operator = new DelayMessageOperator();
        try {
            operator.handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        operator.message = message;
        return operator;
    }

    public void setDelayTime(Long delayTime, TimeUnit timeUnit) {
        Long fireTime = TimeUnit.MILLISECONDS.convert(delayTime, timeUnit) + System.currentTimeMillis();
        this.handler.setDelayTime(this.message, fireTime);
    }

    public void setScheduleTime(Date scheduleTime) {
        this.handler.setDelayTime(this.message, scheduleTime.getTime());
    }

    static {
        handlerMap.put(Message.class, RocketmqMessageOperatorHandler.class);
    }
}

