/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.stream.delay;

import cn.com.duiba.cloud.stream.delay.DelayProperties;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Aspect
public class RocketMQProducerAspect {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducerAspect.class);
    @Resource
    private DelayProperties delayProperties;
    @Value(value="${spring.application.name}")
    private String appName;

    @Around(value="execution(* org.apache.rocketmq.client.producer.DefaultMQProducer.send*(org.apache.rocketmq.common.message.Message,..))")
    public Object messagePreProcessor(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        Message message = (Message)args[0];
        Map properties = message.getProperties();
        long delayTime = Long.valueOf(properties.getOrDefault("$_DELAY_MESSAGE_TIME", "0"));
        if (delayTime <= 0L) {
            return point.proceed();
        }
        if (message.getBody() != null && message.getBody().length > this.delayProperties.getMaxMessageSize()) {
            throw new IllegalArgumentException("\u5ef6\u65f6\u6d88\u606f\u4f53\u8d85\u8fc7\u6700\u5927\u9650\u5236:" + this.delayProperties.getMaxMessageSize() + "byte");
        }
        String topic = message.getTopic();
        if (StringUtils.equals((CharSequence)topic, (CharSequence)this.delayProperties.getDelayTopic())) {
            throw new IllegalArgumentException("\u5ef6\u65f6\u6d88\u606f\u7684topic\u4e0e\u5ef6\u65f6\u6d88\u606f\u4e13\u7528topic\u76f8\u540c,\u6216\u8005\u8bf7\u68c0\u67e5\u540c\u4e00\u4e2a\u5ef6\u65f6\u7684Message\u662f\u5426\u53d1\u5e03\u4e86\u4e24\u6b21");
        }
        properties.put("$$_DELAY_MESSAGE_TOPIC", topic);
        properties.put("$$_SOURCE_APP_NAME", this.appName);
        message.setTopic(this.delayProperties.getDelayTopic());
        return point.proceed();
    }
}

