package cn.com.duiba.cloud.zhongyan.order.service.api.enums;

import java.util.HashMap;
import java.util.Map;
import lombok.Getter;

/**
 * ems 订单状态
 *
 * @author xuanhongjian
 */
@Getter
public enum EmsOrderStateEnum {

    /**
     * 主订单状态在 待支付-待审核之后 会转到待完成 直到所有的子订单状态都到终态
     */
    WAIT_COMPLETION(1, "待完成"),

    WAIT_PAY(10, "待支付"),
    WAIT_REVIEW(20, "待审核"),
    WAIT_SHIPMENT(30, "待发货"),
    SHIPPING(35, "发货中"),
    SHIPPING_EXCEPTION(37, "发货异常"),
    WAIT_TAKE_DELIVERY(40, "待收货"),
    ORDER_COMPLETION(50, "交易完成"),

    ORDER_SUCCESS(90, "交易成功"),
    ORDER_CLOSE(91, "交易关闭"),
    ORDER_ERROR(99, "异常状态"),
    ;
    private static Map<Integer, OrderStatusEnum> map = new HashMap<Integer, OrderStatusEnum>() {{
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            put(statusEnum.getStatus(), statusEnum);
        }
    }};
    private static Map<String, OrderStatusEnum> descMap = new HashMap<String, OrderStatusEnum>() {{
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            put(statusEnum.getDesc(), statusEnum);
        }
    }};
    private Integer status;
    private String desc;

    EmsOrderStateEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static OrderStatusEnum getByStatus(Integer status) {
        return map.get(status);
    }

    public static OrderStatusEnum getByDesc(String desc) {
        return descMap.get(desc);
    }

}
