package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import cn.com.duiba.cloud.zhongyan.order.service.api.enums.EmsDeliverGoodsTaskStateEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class EmsDeliverGoodsListDTO implements Serializable {

    private static final long serialVersionUID = 369989076992658429L;
    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 发货状态 {@link EmsDeliverGoodsTaskStateEnum}
     */
    private Integer deliverGoodsState;
    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 收件人姓名
     */
    private String receiverName;

    /**
     * 收件人手机号 脱敏
     */
    private String receiverPhone;

    /**
     * 收货地址
     */
    private String addressDetail;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 发货时间
     */
    private Date deliveryDate;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 商品数量
     */
    private Integer goodsCount;

    /**
     * 发货异常订单异常code
     */
    private String errorCode;

    /**
     * 发货异常订单异常原因
     */
    private String errorDesc;

    /**
     * 子订单列表
     */
    private List<SubOrderDTO> subOrders;
}
