package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/18 3:07 下午
 **/
@Data
public class OrderAddressDetailDTO implements Serializable {

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     */
    private Integer buyerType;

    /**
     * 卖家类型
     */
    private Integer sellerType;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 订单状态
     */
    private Integer status;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源
     */
    private Long orderSource;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类型
     */
    private List<Integer> goodsType;

    /**
     * 商品来源
     */
    private List<Integer> goodsSource;

    /**
     * 收件人地址--省份
     */
    private String receivingProvince;

    /**
     * 收件人地址--城市
     */
    private String receivingCity;

    /**
     * 收件人地址--区县
     */
    private String receivingArea;

    /**
     * 收件人地址--详细地址
     */
    private String receivingAddress;

    /**
     * 收件人-名称
     */
    private String receivingName;

    /**
     * 收件人手机号
     */
    private String receivingTelephone;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 发货时间
     */
    private Date deliverTime;

    /**
     * 物流单号
     */
    private List<String> logisticsCode;

    /**
     * 商品数量
     */
    private Integer goodsNum;

    /**
     * 是否ems订单
     */
    private Boolean isEms;

    /**
     * 发货异常订单异常code
     */
    private String errorCode;

    /**
     * 发货异常订单异常原因
     */
    private String errorDesc;
}