package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class EsQueryParam extends PageRequest {

    /**
     * 创建时间 开始
     */
    private Date createTimeStart;

    /**
     * 创建时间 结束
     */
    private Date createTimeEnd;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 买家id
     */
    private Long buyerId;

    /**
     * 买家类型
     */
    private Integer buyerType;

    /**
     * 卖家类型
     */
    private Integer sellerType;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 订单状态
     */
    private Integer status;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类型
     */
    private List<Integer> goodsType;

    /**
     * 商品来源
     */
    private List<Integer> goodsSource;

    /**
     * 收件人地址--省份
     */
    private String receivingProvince;

    /**
     * 收件人地址--城市
     */
    private String receivingCity;

    /**
     * 收件人地址--区县
     */
    private String receivingArea;

    /**
     * 收件人地址--详细地址
     */
    private String receivingAddress;

    /**
     * 收件人-名称
     */
    private String receivingName;

    /**
     * 收件人手机号
     */
    private String receivingTelephone;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 发货开始时间
     */
    private Date deliverStartTime;

    /**
     * 发货结束时间
     */
    private Date deliverEndTime;

    /**
     * 物流单号
     */
    private List<String> logisticsCode;

    /**
     * 不在某个省内
     */
    private String notReceivingProvince;

    /**
     * 是否ems订单
     */
    private Boolean isEms;

    /**
     * 是否需要查询ems异常订单
     */
    private boolean emsException = false;

    /**
     * 订单多状态查询
     */
    private List<Integer> orderStates;

    /**
     * 订单编号
     */
    private List<String> orderCodes;
}