package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import cn.com.duiba.cloud.zhongyan.order.service.api.enums.EmsDeliverGoodsStateEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * ems 发货列表查询
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class QueryEmsDeliverGoodsListParam extends PageRequest {
    private static final long serialVersionUID = 369989076992658429L;
    /**
     * 下单开始时间
     */
    @NotNull(message = "下单时间不能为空")
    private Date createOrderStartDate;

    /**
     * 下单结束时间
     */
    @NotNull(message = "下单时间不能为空")
    private Date createOrderEndDate;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;

    /**
     * 浙江省外
     */
    private Integer notZheJiang;

    /**
     * 发货开始时间
     */
    private Date deliveryStartDate;

    /**
     * 发货结束时间
     */
    private Date deliveryEndDate;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 订单编号
     */
    private String orderCode;
    private List<String> orderCodes;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 收件人手机号
     */
    private String phone;

    /**
     * 购买人
     */
    private Long buyerId;

    /**
     * 收件人名称
     */
    private String receiverName;


    /**
     * 排序字段 {@link cn.com.duiba.cloud.zhongyan.order.service.api.enums.SortEnum}
     */
    private String sortRule;

    /**
     * 1:"待发货", 2 "已发货" , 3："发货异常" {@link EmsDeliverGoodsStateEnum}
     */
    private Integer deliverGoodsState;

    /**
     * 批任务id
     */
    private Long batchId;

    private Boolean isInternalCall;
}
