package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/8/2 15:38
 **/
@Getter
@Setter
public class RemoteAuditOrderParam implements Serializable {

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 操作人
     */
    @NotNull(message = "操作人不能为空")
    private Long operator;

    /**
     * 审核状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum#PASS
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum#REFUSE
     */
    @NotNull(message = "审核状态不能为空")
    private Integer type;

    /**
     * 备注（审核拒绝时必填）
     */
    private String remark;
}
