package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 异常订单重新发起下单
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/22
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteReSubmitExceptionOrderParam implements Serializable {

    private static final long serialVersionUID = 6338687499128690593L;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderCode;

    /**
     * 操作人
     */
    @NotNull(message = "操作人不能为空")
    private Long operator;

}
