package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import cn.com.duiba.cloud.zhongyan.order.service.api.enums.EmsDeliverGoodsStateEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @author xuanhongjian
 */
@Data
public class StatisticsDeliverInfoParam implements Serializable {
    private static final long serialVersionUID = -2047825410280095811L;

    /**
     * 下单开始时间
     */
    @NotNull(message = "下单时间不能为空")
    private Date createOrderStartDate;

    /**
     * 下单结束时间
     */
    @NotNull(message = "下单时间不能为空")
    private Date createOrderEndDate;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;

    /**
     * 浙江省外
     */
    private Integer notZheJiang;

    /**
     * 发货开始时间
     */
    private Date deliveryStartDate;

    /**
     * 发货结束时间
     */
    private Date deliveryEndDate;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单编号多选
     */
    private List<String> orderCodes;

    /**
     * 物流单号
     */
    private String logisticsNo;

    /**
     * 收件人手机号
     */
    private String phone;

    /**
     * 收件人
     */
    private Long buyerId;

    /**
     * 1:"待发货", 2 "已发货" , 3："发货异常" {@link EmsDeliverGoodsStateEnum}
     */
    private Integer deliverGoodsState;
}
