package cn.com.duiba.cloud.zhongyan.order.service.api.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * @author xuanhongjian
 */

@Getter
public enum EmsDeliverGoodsStateEnum {
    /**
     * ems 发货状态
     */
    WAIT_SHIPMENT(1, "待发货"),
    SHIPMENT(2, "已发货"),
    SHIPMENT_EXCEPTION(3, "发货异常");
    private final Integer code;
    private final String desc;

    EmsDeliverGoodsStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final ImmutableMap<Integer, EmsDeliverGoodsStateEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, EmsDeliverGoodsStateEnum> builder = ImmutableMap
                                                                          .builder();
        for (EmsDeliverGoodsStateEnum item : EmsDeliverGoodsStateEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    public static EmsDeliverGoodsStateEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
