package cn.com.duiba.cloud.zhongyan.order.service.api.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
@AllArgsConstructor
public enum EmsDeliverGoodsTaskTypeEnum {
    /**
     * 任务类型
     */
    MAIN_TASK(1, "主任务"),
    SUB_TASKS(2, "子任务");

    private static final ImmutableMap<Integer, EmsDeliverGoodsTaskTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, EmsDeliverGoodsTaskTypeEnum> builder = ImmutableMap
                                                                                 .builder();
        for (EmsDeliverGoodsTaskTypeEnum item : EmsDeliverGoodsTaskTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    public static EmsDeliverGoodsTaskTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
