package cn.com.duiba.cloud.zhongyan.order.service.api.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 排序规则
 *
 * @author xuanhongjian
 */
@Getter
@AllArgsConstructor
public enum SortEnum {
    /**
     * 排序规则
     */
    SALE_NUMBER_ASC("saleNumberAsc", "goodsNum", "asc"),
    SALE_NUMBER_DESC("saleNumberDesc", "goodsNum", "desc"),
    ORDER_DATE_ASC("orderAsc", "createTime", "asc"),
    ORDER_DATE_DESC("orderDesc", "createTime", "desc"),
    DELIVERY_DATE_ASC("deliveryDateAsc", "deliverTime", "asc"),
    DELIVERY_DATE_DESC("deliveryDateDesc", "deliverTime", "desc");

    private static final ImmutableMap<String, SortEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<String, SortEnum> builder = ImmutableMap.builder();
        for (SortEnum item : SortEnum.values()) {
            builder = builder.put(item.sortCode, item);
        }
        INNER_MAP = builder.build();
    }

    private final String sortCode;
    private final String field;
    private final String sortOrder;

    public static SortEnum getByCode(String termValue) {
        return INNER_MAP.get(termValue)==null ? ORDER_DATE_DESC : INNER_MAP.get(termValue);
    }
}
