package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单信息
 * @Author dangcang
 * @Date 2021/11/10 3:36 下午
 **/
@Data
public class BackGroudOrderDTO implements Serializable {

    private static final long serialVersionUID = -8374570092334195500L;

    /**
     * 子订单列表
     */
    private List<SubOrderDTO> subOrderDTOS;

    /**
     * 订单扩展信息查询
     */
    private List<OrderExtraDTO> orderExtraDTOS;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     */
    private Long bizId;

    /**
     * 商品来源
     */
    private Integer goodsSource;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;
}