package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import cn.com.duiba.cloud.zhongyan.order.service.api.enums.BatchStatusEnum;
import cn.com.duiba.cloud.zhongyan.order.service.api.enums.BatchTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/11 11:30 上午
 **/
@Data
public class BatchTaskDTO implements Serializable {

    private static final long serialVersionUID = -5999994968283708842L;
    /**
     * 批量任务id
     */
    private Long batchTaskId;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;

    /**
     * 操作时间
     */
    private Long operatorTime;

    /**
     * 批量任务id
     * @see BatchTypeEnum
     */
    private Integer batchType;

    /**
     * 批量数量
     */
    private Long batchNum;

    /**
     * 成功数量
     */
    private Long successNum;

    /**
     * 任务处理状态
     * @see BatchStatusEnum
     */
    private Integer batchStatus;

    /**
     * 文件地址
     */
    private String filePath;

    /**
     * 结果文件
     */
    private String resultPath;

}