package cn.com.duiba.cloud.zhongyan.order.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 订单信息
 * @Author dangcang
 * @Date 2021/11/10 3:36 下午
 **/
@Data
public class OrderDTO implements Serializable {

    private static final long serialVersionUID = -8374570092334195500L;

    /**
     * 子订单列表
     */
    private List<SubOrderGoodsDTO> subOrderGoodsDTOS;

    /**
     * 订单商品名称
     */
    private String orderName;

    /**
     * 下单时间
     */
    private Long orderTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 订单来源：和orderType合用
     * 订单类型为 OrderTypeEnum#EXCHANGE_ACTIVITY  则为活动id
     */
    private Long bizId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 购买者用户id
     */
    private Long buyerId;

    /**
     * 购买者类型
     */
    private Integer buyerType;

    /**
     * 卖家id
     */
    private Long sellerId;

    /**
     * 卖家类型
     */
    private Integer sellerType;
}