package cn.com.duiba.cloud.zhongyan.order.service.api.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: nongfu
 * @Date: 2023/4/18-09:50
 * @Description:
 */
@Data
public class RemoteBatchAuditOrderParam implements Serializable {

    /**
     * 订单号
     */
    private List<String> orderCodeList;

    /**
     * 操作人
     */
    @NotNull(message = "操作人不能为空")
    private Long operator;

    /**
     * 审核状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum#PASS
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.audit.AuditStateEnum#REFUSE
     */
    @NotNull(message = "审核状态不能为空")
    private Integer type;

    /**
     * 备注（审核拒绝时必填）
     */
    private String remark;
}
