package cn.com.duiba.cloud.zhongyan.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.AddressLibraryDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.CreateAddressLibraryParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.UpdateAddressLibraryParam;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 中烟地址库服务
 *
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteAddressLibraryService {

    /**
     * 中烟发货人地址库新增地址
     *
     * @param param 参数
     * @return 主键
     * @throws BizException 业务异常
     */
    Long createAddress(CreateAddressLibraryParam param) throws BizException;

    /**
     * 分页查询地址列表
     *
     * @param pageRequest 分页参数
     * @return 地址列表
     */
    PageResponse<AddressLibraryDTO> pageQuery(PageRequest pageRequest);

    /**
     * 根据id查询地址列表
     *
     * @param id 主键ID
     * @return 地址详情
     * @throws BizException 业务异常
     */
    AddressLibraryDTO getById(Long id) throws BizException;

    /**
     * 删除地址
     *
     * @param id ID
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean deleteById(Long id) throws BizException;

    /**
     * 更新地址
     *
     * @param param 参数
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean updateAddress(UpdateAddressLibraryParam param) throws BizException;
}
