package cn.com.duiba.cloud.zhongyan.order.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.EmsDeliverGoodsCountDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.EmsDeliverGoodsListDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.EmsDeliverGoodsResultDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.EmsDeliverGoodsTaskDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.EmsLogisticsTracesDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.EmsStatisticsDeliverGoodsDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.ExportOrderDTO;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.dto.QueryEmsDeliverTaskParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.DownLoadEmsResultParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.EmsDeliverGoodsParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.ExportEmsDeliverGoodsParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.QueryEmsDeliverGoodsCountParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.QueryEmsDeliverGoodsListParam;
import cn.com.duiba.cloud.zhongyan.order.service.api.model.param.StatisticsDeliverInfoParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteEmsDeliverGoodsService {

    /**
     * ems 发货查询列表
     *
     * @param queryEmsDeliverGoodsListParam 查询参数
     * @return ems列表
     * @throws BizException 业务异常
     */
    PageResponse<EmsDeliverGoodsListDTO> queryEmsDeliverGoods(
        QueryEmsDeliverGoodsListParam queryEmsDeliverGoodsListParam) throws BizException;

    /**
     * 统计发货信息
     *
     * @param statisticsDeliverInfoParam 查询参数
     * @return 统计信息
     * @throws BizException 业务异常
     */
    EmsStatisticsDeliverGoodsDTO statisticsDeliverInfo(
        StatisticsDeliverInfoParam statisticsDeliverInfoParam ) throws BizException;


    /**
     * 分页查询批任务列表
     *
     * @param param 参数
     * @return 批任务列表
     */
    PageResponse<EmsDeliverGoodsTaskDTO> queryEmsDeliverGoodsTask(QueryEmsDeliverTaskParam param);

    /**
     * ems  发货
     *
     * @param param 参数
     * @return 发货结果
     * @throws BizException 业务异常
     */
    EmsDeliverGoodsResultDTO emsDeliverGoods(EmsDeliverGoodsParam param) throws BizException;

    /**
     * 查询订单物流轨迹
     *
     * @param orderCode 主订单编号
     * @return 订单物流轨迹
     * @throws BizException 业务异常
     */
    EmsLogisticsTracesDTO getTraceByOrderCode(String orderCode) throws BizException;

    /**
     * 导出ems 发货列表
     *
     * @param param 导出条件
     * @return 导出结果
     * @throws BizException 业务异常
     */
    ExportOrderDTO exportEmsDeliverGoods(ExportEmsDeliverGoodsParam param) throws BizException;

    /**
     * 导出ems批量发货结果
     *
     * @param param 导出条件
     * @return 导出结果
     * @throws BizException 业务异常
     */
    ExportOrderDTO exportEmsDeliverGoodsTask(DownLoadEmsResultParam param) throws BizException;

    /**
     * ems统计总数发货结果
     *
     * @param param 参数
     * @return 数目
     * @throws BizException 业务异常
     */
    EmsDeliverGoodsCountDTO queryEmsDeliverGoodsCount(QueryEmsDeliverGoodsCountParam param)
        throws BizException;
}
