package cn.com.duiba.collect.card.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.collect.card.center.api.dto.record.CollectCardWinRecordDTO;

import java.util.List;

/**
 * RemoteCollectCardWinRecordService
 *
 * @author ChenXiangge
 * @date 2018/9/11
 */
@AdvancedFeignClient
public interface RemoteCollectCardWinRecordService {
    /**
     * 新增集卡获奖记录
     * @param winRecordDTO
     * @return
     */
    Integer insertWinRecord(CollectCardWinRecordDTO winRecordDTO);

    /**
     * 查询用户获奖记录（指定规则 - 指定等级）
     * @param consumerId
     * @param ruleType
     * @param ruleId
     * @param gradeLevel
     * @return
     */
    List<CollectCardWinRecordDTO> findConsumerWinRecordByGrade(Long consumerId, Integer ruleType, Long ruleId, Integer gradeLevel);


    /**
     * 查询用户获奖记录（指定规则 - 用于多奖项限制）
     * @param consumerId
     * @param ruleType
     * @param ruleId
     * @return
     */
    List<CollectCardWinRecordDTO> findConsumerWinRecord(Long consumerId, Integer ruleType, Long ruleId);

}
