package cn.com.duiba.collect.card.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.collect.card.center.api.dto.activity.CollectCardItemDto;
import cn.com.duiba.collect.card.center.api.dto.request.CollectCardItemSaveRequest;

import java.util.List;

/**
 * Created by fangdong on 2019/03/04
 */
@AdvancedFeignClient
public interface RemoteCollectCardItemBackendService {

    /**
     * 获取
     * @param id 卡片id
     * @return 卡片
     * @throws BizException
     */
    CollectCardItemDto getById(Long id) throws BizException;

    /**
     * 列表
     * @param ids 卡片列表id
     * @return 卡片列表
     * @throws BizException
     */
    List<CollectCardItemDto> listByIds(List<Long> ids) throws BizException;

    /**
     * 新增卡片列表
     * @param items
     * @return
     * @throws BizException
     */
    List<Long> insertList(List<CollectCardItemSaveRequest> items) throws BizException;

    /**
     * 更新卡片列表
     * @param items
     * @return
     * @throws BizException
     */
    Integer updateList(List<CollectCardItemSaveRequest> items) throws BizException;
}
