package cn.com.duiba.consumer.center.api.dto;

import cn.com.duiba.consumer.center.api.enums.CreditsLogChangeTypeEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by fangdong on 2018/09/30
 */
public class ConsumerCreditsLogParamDto implements Serializable {
    private static final long serialVersionUID = 4055412520633310694L;

    /**
     * consumer id
     * required
     */
    private Long consumerId;

    /**
     * 订单业务类型
     * {@link cn.com.duiba.api.enums.subcredits.SubCreditsOuterType}
     * {@link cn.com.duiba.api.enums.addcredits.AddCreditsOuterType}
     */
    private String bizType;

    /**
     * 业务id
     */
    private String bizId;

    /**
     * 变动类型
     */
    private CreditsLogChangeTypeEnum changeType;

    /**
     * 起始下单时间
     */
    private Date beginOrderTime;

    /**
     * 结束下单时间
     */
    private Date endOrderTime;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Date getBeginOrderTime() {
        return beginOrderTime;
    }

    public void setBeginOrderTime(Date beginOrderTime) {
        this.beginOrderTime = beginOrderTime;
    }

    public Date getEndOrderTime() {
        return endOrderTime;
    }

    public void setEndOrderTime(Date endOrderTime) {
        this.endOrderTime = endOrderTime;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public CreditsLogChangeTypeEnum getChangeType() {
        return changeType;
    }

    public void setChangeType(CreditsLogChangeTypeEnum changeType) {
        this.changeType = changeType;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
