package cn.com.duiba.consumer.center.api.enums;

/**
 * @Author: liukai
 * @Description:   新用户参与活动枚举类型
 * @Date: Created in 2018/12/26
 */
public enum ConsumerBizJoinEnum {

    LOTTERYSQUARE(1,"lotterySquare"),
    ;

    private Integer type;
    private String desc;

    ConsumerBizJoinEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static ConsumerBizJoinEnum getByType(Integer type){
        for(ConsumerBizJoinEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
