package cn.com.duiba.consumer.center.api.remoteservice;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by wenqi.huang on 16/4/8.
 */
@AdvancedFeignClient
public interface RemoteConsumerService {
	/**
	 * 
	 * @param consumerId
	 * @return
	 */
    public ConsumerDto find(Long consumerId);
    /**
     * 
     * @param ids
     * @return
     */
    public List<ConsumerDto> findAllByIds(List<Long> ids);
    /**
     * 根据App和开发者用户id查询兑吧用户Consumer
     * @param appId
     * @param partnerUserId
     * @midified by zhangpan
     * @return
     */
    public ConsumerDto findByAppAndPartnerUserId(Long appId, String partnerUserId);

    /**
     * 根据appId和兑吧用户id查询开发者用户id
     * @param appId
     * @param consumerId
     * @return
     */
    String findPartnerUserIdByConsumerId(Long appId, Long consumerId);


    /**
     * 添加一个用户
     * @param consumer
     * @return
     */
    public ConsumerDto insert(ConsumerDto consumer);

    /**
     * 更新用户积分，主要用在自动登录处
     * @param consumerId
     * @param credits
     * @midified by zhangpan
     * @return
     */
    public int updateCredits(Long consumerId, Long credits);
    /**
     * 用户积分进行增加
     * @param consumerId
     * @param credits
     * @midified by zhangpan
     * @return
     */
    public int increaseCredits(Long consumerId, Long credits);
    /**
     * 用户积分进行减少
     * @param consumerId
     * @param credits
     * @midified by zhangpan
     * @return
     */
    public int decrementCredits(Long consumerId, Long credits);
    
    /**
     * 
     * @param consumerId
     * @param credits
     * @param alipay
     * @param qq
     * @param phone
     * @param vipLevel
     * @return
     */
    public int updateAutologinParams(Long consumerId, Long credits, String alipay, String qq, String phone, Integer vipLevel);
    /**
     * 
     * @param consumerId
     * @param count
     * @return
     */
    public int updateUnreadCount(Long consumerId, int count);
    /**
     * 更新最近一次填写的支付宝信息
     * @param consumerId
     * @param lastAlipay
     * @param lastRealname
     * @return
     */
    public int updateLastAlipay(Long consumerId, String lastAlipay, String lastRealname);

    /**
     * 更新最近一次填写的收货信息
     * @param consumerId
     * @param addrName
     * @param addrProvince
     * @param addrCity
     * @param addrArea
     * @param addrDetail
     * @param addrPhone
     * @return
     */
    public int updateAddress(Long consumerId, String addrName, String addrProvince, String addrCity, String addrArea,
                             String addrDetail, String addrPhone);
    /**
     * 更新用户最后一次填写号码
     * @param consumerId
     * @param lastPhone
     * @return
     */
    public int updateLastPhone(Long consumerId, String lastPhone);
    /**
     * 更新最后一次填写的QQ
     * @param consumerId
     * @param lastQq
     * @return
     */
    public int updateLastQq(Long consumerId, String lastQq);

    /**
     * 更新/添加/删除扩展字段到json字段
     * 删除value填null
     * @param key
     * @param value
     * @return
     */
    DubboResult<Integer> updateExtra(Long consumerId, String key, String value);

    /**
     * 查询扩展字段
     * @param key
     * @return
     */
    DubboResult<String> findExtra(Long consumerId, String key);

    /**
     * 批量更新/添加/删除扩展字段到json字段
     * 删除value填null
     * @param map
     * @return
     */
    DubboResult<Integer> updateExtras(Long consumerId, Map<String,String> map);

    /**
     * 批量查询扩展字段
     * @param keys
     * @return
     */
    DubboResult<Map<String,String>> findExtras(Long consumerId, Set<String> keys);

    /**
     * 判断该用户是否为新用户 true 新用户  false 老用户
     * @param consumerId
     * @return
     */
    Boolean wasNewUser(Long consumerId);
}
