package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.UserInitializeInfoDto;
import cn.com.duiba.consumer.center.api.paramQuery.InitializeParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteUserInitializeInfoService {

	/**
	 * 根据uid查询未初始化用户信息 status=0
	 * @param uid
	 * @return
	 */
	UserInitializeInfoDto findByPartnerUid(Long appId,String uid);

	/**
	 * 更新用户
	 * @param dto
	 * @return
	 */
	Integer updateById(UserInitializeInfoDto dto);

	/**
	 * 删除用户
	 * @param id
	 * @return
	 */
	Integer deleteById(Long id);

	/**
	 * 批量插入用户
	 * @return
	 */
	Integer batchInsert(List<UserInitializeInfoDto> list);

	/**
	 * 批量更新用户
	 * @return
	 */
	Integer batchUpdate(List<UserInitializeInfoDto> list);

	/**
	 * 插入用户
	 * @return
	 */
	Long insert(UserInitializeInfoDto dto);


	/**
	 * 更新appId和status,uid查询用户
	 * @return
	 */
	List<UserInitializeInfoDto> listByParam(InitializeParam param);

	/**
	 * 更新appId和status,uid查询用户
	 * @return
	 */
	List<UserInitializeInfoDto> listByAppIdAndUids(Long appId,List<String> uids);


	/**
	 * 根据条件分页查询
	 * @param param
	 * @return
	 */
	Page<UserInitializeInfoDto> listByPage(InitializeParam param);


	/**
	 * 根据条件分页查询
	 * 只查询未初始化的用户
	 * @param param
	 * @return
	 */
	Page<UserInitializeInfoDto> listUninitByPage(InitializeParam param);

}
