package cn.com.duiba.consumer.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @Author: liukai
 * @Description:   新用户参与活动枚举类型
 * @Date: Created in 2018/12/26
 */
public enum ConsumerBizJoinEnum {

    LOTTERYSQUARE(1,"lotterySquare"),
    ;

    private Integer type;
    private String desc;

    ConsumerBizJoinEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }


    public static final ImmutableMap<Integer, ConsumerBizJoinEnum> ConsumerBizJoinEnum_MAP;

    static {
        Map<Integer, ConsumerBizJoinEnum> temp = Maps.newHashMap();
        for (ConsumerBizJoinEnum consumerBizJoinEnum : values()) {
            temp.put(consumerBizJoinEnum.getType(), consumerBizJoinEnum);
        }
        ConsumerBizJoinEnum_MAP = ImmutableMap.copyOf(temp);
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static ConsumerBizJoinEnum getByType(Integer type){
        return ConsumerBizJoinEnum_MAP.get(type)!=null?ConsumerBizJoinEnum_MAP.get(type):null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
