package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.expire.BeAboutExpireCreditsDto;
import cn.com.duiba.credits.credits.center.api.dto.expire.ConsumeCreditsDto;
import cn.com.duiba.credits.credits.center.api.dto.expire.ExpireTrusteeshipCreditsRecordsDto;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireCreditsParam;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireQueryConsumerParam;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireTrusteeshipCreditsRecordsParam;

import java.util.List;

/**
 * @author fss
 */
@AdvancedFeignClient
public interface RemoteExpireTrusteeshipCreditsRecordsService {
    /**
     * 插入
     * 1.除非有必要,否者推荐使用RemoteTrusteeshipCreditsExpandService.increaseWithRecord
     * 改方法会自动插入流水表
     *
     * @param pojo
     * @return id
     */
    Long insert(ExpireTrusteeshipCreditsRecordsDto pojo) throws BizException;


    /**
     *
     * @param pojo
     * @return
     */
    Page<ExpireTrusteeshipCreditsRecordsDto> recordsPageListForPush(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 分页查询
     *
     * @param pojo
     * @return
     */
    List<ExpireTrusteeshipCreditsRecordsDto> selectList(ExpireTrusteeshipCreditsRecordsParam pojo);

    Long count(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 根据id或者orderNum或者bizId查询
     *
     * @param pojo
     * @return
     */
    ExpireTrusteeshipCreditsRecordsDto selectOne(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 修改
     *
     * @param pojo
     * @return
     */
    int updateById(ExpireTrusteeshipCreditsRecordsDto pojo);

    /**
     * 分页查询
     * @param pojo 查询条件
     * @return
     */
    Page<ExpireTrusteeshipCreditsRecordsDto> recordsPageList(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 查询用户即将过期的积分值
     * @param expireQueryConsumerParam
     * @return 即将过期的积分值
     */
    Long queryConsumerBeAboutExpireCredits(ExpireQueryConsumerParam expireQueryConsumerParam);

    /**
     * 查询用户即将过期的积分列表
     * @param expireQueryConsumerParam
     * @return
     */
    BeAboutExpireCreditsDto pageBeAboutExpireCredits(ExpireQueryConsumerParam expireQueryConsumerParam);


    /**
     * 查询活动明细（分页查询）
     *
     * @param pojo
     * @return
     */
    List<ExpireTrusteeshipCreditsRecordsDto> selectActList(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 查询活动明细记录数
     *
     * @param pojo
     * @return
     */
    Long countAct(ExpireTrusteeshipCreditsRecordsParam pojo);

    /**
     * 查询用户的消耗积分数据
     * @param expireCreditsParam
     * @return
     */
    List<ConsumeCreditsDto> queryUserConsumeCredits(ExpireCreditsParam expireCreditsParam);

    /**
     * 根据扣除积分的场景找到加积分数据的源头(支持入参为 减积分、过期积分类型)
     * @param expireTrusteeshipCreditsRecordsDto
     * @return 返回的数据的credits就是扣积分记录真实消耗积分值可以直接使用
     */
    List<ExpireTrusteeshipCreditsRecordsDto> queryAddRecordListByDeduceRecord(ExpireTrusteeshipCreditsRecordsDto expireTrusteeshipCreditsRecordsDto);
}
