package cn.com.duiba.creditsclub.ecosphere.sdk.data;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ConsumerData implements Serializable {
    public static final String PREVIEWUSERID = "duiba-preview-user"; //用来进行预览的用户id
    public static final String NOTLOGINUSERID = "not_login";    //未登录用户id
    public static final String SHAREUSERID = "share";  //分享用户
    public static final String NOTLOGINUSERID_GEN_NEW = "gen_new_";  //未登录用户 创建用户时  partnerUserId  开头是一次为前缀
    private static final String OPENBS_NOT_LOGIN_GEN = "gen_";  // 通过openBs链接产生的用户partnerUserId以"gen_"开头，此类用户按照未登录用户处理

    /**
     * 主键
     */
    private Long id;

    /**
     * 积分
     */
    private Long credits;

    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 最后一次使用，名称
     */
    private String realName;

    /**
     * VIP等级
     */
    private Integer vipLevel = 0;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * json字段(属于扩展字段)
     */
    private String extJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getCredits() {
        return credits;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPhone() {
        return phone;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getRealName() {
        return realName;
    }

    public void setVipLevel(Integer vipLevel) {
        this.vipLevel = vipLevel;
    }

    public Integer getVipLevel() {
        return vipLevel;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return nickname;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return email;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Integer getSex() {
        return sex;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public boolean isNotLoginUser() {
        return StringUtils.isNotBlank(partnerUserId) && (partnerUserId.equals(NOTLOGINUSERID) || partnerUserId.startsWith(NOTLOGINUSERID_GEN_NEW));
    }
}
