package cn.com.duiba.creditsclub.ecosphere.sdk.pay;

import java.util.HashMap;
import java.util.Map;

public enum WxPayBankEnum {

    ICBC("工商银行","ICBC"),
    ABC("农业银行","ABC"),
    PSBC("邮储银行", "PSBC"),
    CCB("建设银行", "CCB"),
    CMB("招商银行","CMB"),
    BOC("中国银行", "BOC"),
    COMM("交通银行","COMM"),
    SPDB("浦发银行","SPDB"),
    GDB("广发银行","GDB"),
    CMBC("民生银行","CMBC"),
    PAB("平安银行","PAB"),
    CEB("光大银行","CEB"),
    CIB("兴业银行","CIB"),
    CITIC("中信银行","CITIC"),
    BOSH("上海银行","BOSH"),
    AHRCUB("安徽省农村信用社联合","AHRCUB"),
    AIB("百信银行","AIB"),
    ASCB("鞍山银行","ASCB"),
    ATRB("盘山安泰村镇银行","ATRB"),
    BCZ("沧州银行","BCZ"),
    BDB("保定银行","BDB"),
    BEEB("鄞州银行","BEEB"),
    BGZB("贵州银行","BGZB"),
    BHB("河北银行","BHB"),
    BJRCB("北京农商行","BJRCB"),
    BNC("江西银行","BNC"),
    BOB("北京银行","BOB"),
    BOBBG("北部湾银行","BOBBG"),
    BOCD("成都银行","BOCD"),
    BOCDB("承德银行","BOCDB"),
    BOCFB("中银富登村镇银行","BOCFB"),
    BOCTS("焦作中旅银行","BOCTS"),
    BOD("东莞银行","BOD"),
    BOFS("抚顺银行","BOFS"),
    BOHN("海南银行","BOHN"),
    BOIMCB("内蒙古银行","BOIMCB"),
    BOJN("济宁银行","BOJN"),
    BOJX("嘉兴银行","BOJX"),
    BOLB("洛阳银行","BOLB"),
    BOLFB("廊坊银行","BOLFB"),
    BONX("宁夏银行","BONX"),
    BOPDS("平顶山银行","BOPDS"),
    BOPJ("盘锦银行","BOPJ"),
    BOQHB("青海银行","BOQHB"),
    BOSXB("绍兴银行","BOSXB"),
    BOSZS("石嘴山银行","BOSZS"),
    BOTSB("唐山银行","BOTSB"),
    BOZ("张家口银行","BOZ"),
    BSB("包商银行","BSB"),
    BYK("营口银行","BYK"),
    CBHB("渤海银行","CBHB"),
    CCAB("长安银行","CCAB"),
    CDRCB("成都农商银行","CDRCB"),
    CITIB("花期银行","CITIB"),
    CJCCB("江苏长江商业银行","CJCCB"),
    CQB("重庆银行","CQB"),
    CQRCB("重庆农村商业银行","CQRCB"),
    CRB("珠海华润银行","CRB"),
    CSCB("长沙银行","CSCB"),
    CSRCB("常熟农商银行","CSRCB"),
    CSXB("三湘银行","CSXB"),
    CYCB("朝阳银行", "CYCB"),
    CZB("浙商银行","CZB"),
    CZCB("稠州银行","CZCB"),
    CZCCB("长治银行","CZCCB"),
    DANDONGB("丹东银行","DANDONGB"),
    DBSB("星展银行","DBSB"),
    DCSFRB("大城舜丰村镇银行","DCSFRB"),
    DHDYB("德惠敦银村镇银行","DHDYB"),
    DHRB("调兵山惠民村镇银行","DHRB"),
    DLB("大连银行","DLB"),
    DLRCB("大连农商行","DLRCB"),
    DRCB("东莞农商银行","DRCB"),
    DSB("大新银行","DSB"),
    DTCCB("大同银行","DTCCB"),
    DYB("东营银行","DYB"),
    DYCCB("长城华西银行","DYCCB"),
    DYLSB("东营莱商村镇银行","DYLSB"),
    DZB("德州银行","DZB"),
    DZCCB("达州银行","DZCCB"),
    EDRB("鼎业村镇银行","EDRB"),
    ESUNB("玉山银行","ESUNB"),
    FBB("富邦华一银行","FBB"),
    FDB("富滇银行","FDB"),
    FJHXB("福建海峡银行","FJHXB"),
    FJNX("福建农信银行","FJNX"),
    FUXINB("阜新银行","FUXINB"),
    FXLZB("费县梁邹村镇银行","FXLZB"),
    GADRB("贵安新区发展村镇银行","GADRB"),
    GDHX("广东华兴银行","GDHX"),
    GDNYB("南粤银行","GDNYB"),
    GDRCU("广东农信银行","GDRCU"),
    GLB("桂林银行","GLB"),
    GLGMCB("桂林国民村镇银行","GLGMCB"),
    GRCB("广州农商银行","GRCB"),
    GSB("甘肃银行","GSB"),
    GSNX("甘肃农信","GSNX"),
    GSRB("广阳舜丰村镇银行","GSRB"),
    GXNX("广西农信","GXNX"),
    GYCB("贵阳银行","GYCB"),
    GZCB("广州银行","GZCB"),
    GZCCB("赣州银行","GZCCB"),
    GZNX("贵州农信","GZNX"),
    HAINNX("海南农信","HAINNX"),
    HANAB("韩亚银行","HANAB"),
    HBCB("湖北银行","HBCB"),
    HBNX("湖北农信","HBNX"),
    HDCB("邯郸银行","HDCB"),
    HEBNX("河北农信","HEBNX"),
    HFB("恒丰银行","HFB"),
    HKB("汉口银行","HKB"),
    HKBEA("东亚银行","HKBEA"),
    HKUB("海口联合农商银行","HKUB"),
    HLDCCB("葫芦岛银行","HLDCCB"),
    HLDYB("和龙敦银村镇银行","HLDYB"),
    HLJRCUB("黑龙江农信社","HLJRCUB"),
    HMCCB("哈密银行","HMCCB"),
    HNNX("河南农信","HNNX"),
    HRBB("哈尔滨银行","HRBB"),
    HRCB("保德慧融村镇银行","HRCB"),
    HRXJB("华融湘江银行","HRXJB"),
    HSB("徽商银行","HSB"),
    HSBC("恒生银行","HSBC"),
    HSBCC("汇丰银行","HSBCC"),
    HSCB("衡水银行","HSCB"),
    HUIHEB("新疆汇和银行","HUIHEB"),
    HUNNX("湖南农信","HUNNX"),
    HUSRB("湖商村镇银行","HUSRB"),
    HXB("华夏银行","HXB"),
    HZB("杭州银行","HZB"),
    HZCCB("湖州银行","HZCCB"),
    IBKB("企业银行","IBKB"),
    JCBK("晋城银行","JCBK"),
    JDHDB("上海嘉定洪都村镇银行","JDHDB"),
    JDZCCB("景德镇市商业银行","JDZCCB"),
    JHCCB("金华银行","JHCCB"),
    JJCCB("九江银行","JJCCB"),
    JLB("吉林银行","JLB"),
    JLNX("吉林农信","JLNX"),
    JNRCB("江南农商行","JNRCB"),
    JRCB("江阴农商行","JRCB"),
    JSB("江苏银行","JSB"),
    JSHB("晋商银行","JSHB"),
    JSNX("江苏农信","JSNX"),
    JUFENGB("临朐聚丰村镇银行","JUFENGB"),
    JXB("西昌金信村镇银行","JXB"),
    JXNXB("江西农信","JXNXB"),
    JZB("晋中银行","JZB"),
    JZCB("锦州银行","JZCB"),
    KCBEB("天津金城银行","KCBEB"),
    KLB("昆仑银行","KLB"),
    KRCB("昆山农商","KRCB"),
    KSHB("梅州客商银行","KSHB"),
    KUERLECB("库尔勒市商业银行","KUERLECB"),
    LCYRB("陵城圆融村镇银行","LCYRB"),
    LICYRB("历城圆融村镇银行","LICYRB"),
    LJB("龙江银行","LJB"),
    LLB("山东兰陵村镇银行","LLB"),
    LLHZCB("柳林汇泽村镇银行","LLHZCB"),
    LNNX("辽宁农信","LNNX"),
    LPCB("凉山州商业银行","LPCB"),
    LPSBLVB("钟山凉都村镇银行","LPSBLVB"),
    LSB("临商银行","LSB"),
    LSCCB("乐山市商业银行","LSCCB"),
    LUZB("柳州银行","LUZB"),
    LWB("莱商银行","LWB"),
    LYYHB("辽阳银行","LYYHB"),
    LZB("兰州银行","LZB"),
    LZCCB("泸州市商业银行","LZCCB"),
    MHBRB("闵行上银村镇银行","MHBRB"),
    MINTAIB("民泰银行","MINTAIB"),
    MPJDRB("牟平胶东村镇银行","MPJDRB"),
    MYCCB("绵阳市商业银行","MYCCB"),
    NBCB("宁波银行","NBCB"),
    NCB("宁波通商银行","NCB"),
    NCBCB("南洋商业银行","NCBCB"),
    NCCB("四川天府银行","NCCB"),
    NJCB("南京银行","NJCB"),
    NJJDRB("宁津胶东村镇银行","NJJDRB"),
    NJXLRB("内江兴隆村镇银行","NJXLRB"),
    NMGNX("内蒙古农信","NMGNX"),
    NNGMB("南宁江南国民村镇银行","NNGMB"),
    NUB("辽宁振兴银行","NUB"),
    NYCCB("南阳村镇银行","NYCCB"),
    OCBCWHCB("华侨永亨银行","OCBCWHCB"),
    OHVB("鄂托克旗汇泽村镇银行","OHVB"),
    ORDOSB("鄂尔多斯银行","ORDOSB"),
    PBDLRB("平坝鼎立村镇银行","PBDLRB"),
    PJDWHFB("大洼恒丰村镇银行","PJDWHFB"),
    PJJYRB("浦江嘉银村镇银行","PJJYRB"),
    PZHCCB("攀枝花银行","PZHCCB"),
    QDCCB("青岛银行","QDCCB"),
    QHDB("秦皇岛银行","QHDB"),
    QHJDRB("齐河胶东村镇银行","QHJDRB"),
    QHNX("青海农信","QHNX"),
    QJSYB("衢江上银村镇银行","QJSYB"),
    QLB("齐鲁银行","QLB"),
    QLVB("青隆村镇银行","QLVB"),
    QSB("齐商银行","QSB"),
    QZCCB("泉州银行","QZCCB"),
    RHCB("长子县融汇村镇银行","RHCB"),
    RQCZB("任丘村镇银行","RQCZB"),
    RXYHB("瑞信村镇银行","RXYHB"),
    RZB("日照银行","RZB"),
    SCB("渣打银行","SCB"),
    SCNX("四川农信","SCNX"),
    SDEB("顺德农商行","SDEB"),
    SDRCU("山东农信","SDRCU"),
    SHHJB("商河汇金村镇银行","SHHJB"),
    SHINHAN("新韩银行","SHINHAN"),
    SHRB("上海华瑞银行","SHRB"),
    SJB("盛京银行","SJB"),
    SNB("苏宁银行","SNB"),
    SNCCB("遂宁银行","SNCCB"),
    SPDYB("四平铁西敦银村镇银行","SPDYB"),
    SRB("上饶银行","SRB"),
    SRCB("上海农商银行","SRCB"),
    SUZB("苏州银行","SUZB"),
    SXNX("山西农信","SXNX"),
    SXXH("陕西信合","SXXH"),
    SZRCB("深圳农商银行","SZRCB"),
    TACCB("泰安银行","TACCB"),
    TCRCB("太仓农商行","TCRCB"),
    TJB("天津银行","TJB"),
    TJBHB("天津滨海农商行","TJBHB"),
    TJHMB("天津华明村镇银行","TJHMB"),
    TJNHVB("天津宁河村镇银行","TJNHVB"),
    TLB("铁岭银行","TLB"),
    TLVB("铁岭新星村镇银行","TLVB"),
    TMDYB("图们敦银村镇银行","TMDYB"),
    TRCB("天津农商","TRCB"),
    TZB("台州银行","TZB"),
    UOB("大华银行","UOB"),
    URB("联合村镇银行","URB"),
    VBCB("村镇银行","VBCB"),
    WACZB("武安村镇银行","WACZB"),
    WB("友利银行","WB"),
    WEB("微众银行","WEB"),
    WEGOB("蓝海银行","WEGOB"),
    WFB("潍坊银行","WFB"),
    WHB("威海商业银行","WHB"),
    WHRC("武汉农商行","WHRC"),
    WHRYVB("芜湖圆融村镇银行","WHRYVB"),
    WJRCB("吴江农商行","WJRCB"),
    WLMQB("乌鲁木齐银行","WLMQB"),
    WRCB("无锡农商行","WRCB"),
    WUHAICB("乌海银行","WUHAICB"),
    WZB("温州银行","WZB"),
    WZMSB("温州民商","WZMSB"),
    XAB("西安银行","XAB"),
    XCXPB("许昌新浦村镇银行","XCXPB"),
    XHB("大连鑫汇村镇银行","XHB"),
    XHNMB("安顺西航南马村镇银行","XHNMB"),
    XIB("厦门国际银行","XIB"),
    XINANB("安徽新安银行","XINANB"),
    XJB("新疆银行","XJB"),
    XJJDRB("夏津胶东村镇银行","XJJDRB"),
    XJRCCB("新疆农信银行","XJRCCB"),
    XMCCB("厦门银行","XMCCB"),
    XRTB("元氏信融村镇银行","XRTB"),
    XTB("邢台银行","XTB"),
    XWB("新网银行","XWB"),
    XXCB("新乡银行","XXCB"),
    XXHZCB("兴县汇泽村镇银行","XXHZCB"),
    XXRB("新乡新兴村镇银行","XXRB"),
    XYPQZYCB("信阳平桥中原村镇银行","XYPQZYCB"),
    XZB("西藏银行","XZB"),
    YACCB("雅安市商业银行","YACCB"),
    YBCCB("宜宾商业银行","YBCCB"),
    YKCB("营口沿海银行","YKCB"),
    YLB("亿联银行","YLB"),
    YNHTB("云南红塔银行","YNHTB"),
    YNRCCB("云南农信","YNRCCB"),
    YQCCB("阳泉市商业银行","YQCCB"),
    YQMYRB("玉泉蒙银村镇银行","YQMYRB"),
    YRRCB("黄河农商银行","YRRCB"),
    YTB("烟台银行","YTB"),
    YYBSCB("沂源博商村镇银行","YYBSCB"),
    ZCRB("遵义新蒲长征村镇银行","ZCRB"),
    ZGB("自贡银行","ZGB"),
    ZGCB("北京中关村银行","ZGCB"),
    ZHCB("庄河汇通村镇银行","ZHCB"),
    ZHQYTB("沾化青云村镇银行","ZHQYTB"),
    ZJB("紫金农商银行","ZJB"),
    ZJLXRB("兰溪越商银行","ZJLXRB"),
    ZJRCUB("浙江农信","ZJRCUB"),
    ZJTLCB("浙江泰隆银行","ZJTLCB"),
    ZRCB("张家港农商行","ZRCB"),
    ZSXKCCB("中山小榄村镇银行","ZSXKCCB"),
    ZYB("中原银行","ZYB"),
    ZZB("郑州银行","ZZB"),
    ZZCCB("枣庄银行","ZZCCB");


    WxPayBankEnum(String bankName,String bankCode){
        this.bankName = bankName;
        this.bankCode = bankCode;
    }
    private static final Map<String, WxPayBankEnum> ALL_ENUM_MAP = new HashMap<>();
    static{
        for(WxPayBankEnum bank : values()){
            ALL_ENUM_MAP.put(bank.getBankName(), bank);
        }
    }

    public static WxPayBankEnum getBank(String bankName) {
        return ALL_ENUM_MAP.get(bankName);
    }


    /** 银行名称 */
    private String bankName;
    /** 银行编码 */
    private String bankCode;


    public String getBankName() {
        return bankName;
    }
    public String getBankCode() {
        return bankCode;
    }
}
