package cn.com.duiba.creditsclub.ecosphere.sdk.playway.luckycode;

import cn.com.duiba.creditsclub.ecosphere.sdk.UserRequestApi;

import java.util.Date;
import java.util.List;


public interface LuckycodeUserRequestApi extends UserRequestApi {
    /**
     * 给用户添加一条幸运码
     * @param periodical 期次
     * @param code 幸运码
     * @param prizeDegree 中奖级别
     * @param prizeId 奖品id
     * @param sendPrizeTime 发奖时间，如果是未来发奖，可以在此处传空，并在将来发奖时更新
     */
    void addMyLuckycode(String periodical, String code, String prizeDegree, String prizeId, Date sendPrizeTime);

    /**
     * 查询当前用户某期的幸运码列表
     *
     * @param periodical 期次
     * @return
     */
    List<Luckycode> queryMyLuckycodeList(String periodical);


    /**
     * 查询当前用户所有的历史记录,按期次聚合(未排序)
     *
     * @return
     */
    List<LuckyCodePeriodicalRecord> queryMyHistoryList();

}
