package cn.com.duiba.creditsclub.ecosphere.sdk.redacc;

/**
 * 用户账户充值响应类
 */
public class AccountModifyResponse extends CommonCenterResponseDto {

    private static final long serialVersionUID = 5586888283133147030L;

    /**
     * 钱包账户定制 由于未通过预算校验导致的充值失败 上游需要进行特殊处理
     */
    public static final int ERROR_CODE_FOR_UN_BUDGET = 1;

    /**
     * 本次变动金额，单位：分
     */
    private Long changeMoney;
    /**
     * 变动后余额
     */
    private Long balanceAmount;
    /**
     * 错误信息
     */
    private String errorMsg;


    public static AccountModifyResponse fail(String errorMsg, Integer errCode) {
        AccountModifyResponse response = new AccountModifyResponse();
        response.setSuccess(Boolean.FALSE);
        response.setErrorMsg(errorMsg);
        response.setErrorCode(errCode);
        return response;
    }

    public static AccountModifyResponse succ(Long balanceAmount, Long changeMoney) {
        AccountModifyResponse response = new AccountModifyResponse();
        response.setSuccess(Boolean.TRUE);
        response.setBalanceAmount(balanceAmount);
        response.setChangeMoney(changeMoney);
        return response;
    }

    public Long getChangeMoney() {
        return changeMoney;
    }

    public void setChangeMoney(Long changeMoney) {
        this.changeMoney = changeMoney;
    }

    public Long getBalanceAmount() {
        return balanceAmount;
    }

    public void setBalanceAmount(Long balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
