package cn.com.duiba.creditsclub.ecosphere.sdk.redacc;

import java.util.HashMap;

/**
 * 活动统一编码,新定义code从200起步
 * 维护文档：http://cf.dui88.com/pages/viewpage.action?pageId=13682861
 */
public enum  ActivityUniformityTypeEnum {

    /**
     * 本地化模板活动类型,从10001起自增
     */
    creditsclub(10000, "本地化默认活动类型"),
    ;

    private static HashMap<Integer, ActivityUniformityTypeEnum> typeMap = new HashMap<>();
    static{
        for(ActivityUniformityTypeEnum type : values()){
            typeMap.put(type.getCode(), type);
        }
    }

    public static ActivityUniformityTypeEnum getByCode(Integer code){
        return typeMap.get(code);
    }

    private Integer code;
    private String desc;

    ActivityUniformityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
