package cn.com.duiba.creditsclub.ecosphere.sdk.utils;


import cn.com.duiba.creditsclub.ecosphere.sdk.BizError;
import cn.com.duiba.creditsclub.ecosphere.sdk.BizRuntimeException;
import cn.com.duiba.creditsclub.ecosphere.sdk.ErrorCode;

public class Conditions {
    public static void expectFalse(boolean expression, BizError bizError) {
        expectFalse(expression, bizError.errorCode(), bizError.errorMessage());
    }

    public static void expectFalse(boolean expression, String errorMessage) {
        expectFalse(expression, ErrorCode.ERR_10000, errorMessage);
    }

    public static void expectFalse(boolean expression, int errorCode, String errorMessage) {
        if (expression) {
            throw new BizRuntimeException(errorCode, errorMessage);
        }
    }

    public static void expectAllTrue(BizError bizError, boolean... expressions) {
        expectAllTrue(bizError.errorCode(), bizError.errorMessage(), expressions);
    }

    public static void expectAllTrue(String errorMessage, boolean... expressions) {
        expectAllTrue(ErrorCode.ERR_10000, errorMessage, expressions);
    }

    public static void expectAllTrue(int errorCode, String errorMessage, boolean... expressions) {
        for (boolean b : expressions) {
            expectTrue(b, errorCode, errorMessage);
        }
    }

    public static void expectTrue(boolean expression, BizError bizError) {
        expectTrue(expression, bizError.errorCode(), bizError.errorMessage());
    }

    public static void expectTrue(boolean expression, String errorMessage) {
        expectTrue(expression, ErrorCode.ERR_10000, errorMessage);
    }

    public static void expectTrue(boolean expression, int errorCode, String errorMessage) {
        if (!expression) {
            throw new BizRuntimeException(errorCode, errorMessage);
        }
    }

    public static <T> T expectNotNull(T reference, BizError bizError) {
        return expectNotNull(reference, bizError.errorCode(), bizError.errorMessage());
    }

    public static <T> T expectNotNull(T reference, String errorMessage) {
        return expectNotNull(reference, ErrorCode.ERR_10000, errorMessage);
    }

    public static <T> T expectNotNull(T reference, int code, String errorMessage) {
        if (reference == null) {
            throw new BizRuntimeException(code, errorMessage);
        } else {
            return reference;
        }
    }
}
