package cn.com.duiba.creditsclub.ecosphere.sdk.utils;

import cn.com.duiba.creditsclub.ecosphere.sdk.Api;
import cn.com.duiba.creditsclub.ecosphere.sdk.BizRuntimeException;
import cn.com.duiba.creditsclub.ecosphere.sdk.data.ConsumerData;

import java.util.List;

public interface ConsumerApi extends Api {

    /**
     * 根据用户id获取用户信息
     *
     * @param consumerId
     * @return
     */
    ConsumerData getConsumerData(Long consumerId);

    /**
     * 批量获取用户信息
     *
     * @param ids consumer ids
     * @return list
     * @throws BizRuntimeException exception
     */
    List<ConsumerData> listConsumerByConsumerIds(List<Long> ids) throws BizRuntimeException;

    /**
     * 当前用户是否为新用户
     * true 新用户  false 老用户
     *
     * @param consumerId consumerId
     * @return boolean
     * @throws BizRuntimeException exception
     */
    boolean isNewUser(Long consumerId) throws BizRuntimeException;

    /**
     * 通过开发者用户id获取用户信息
     *
     * @param partnerUserId 开发者用户id
     * @return consumer
     * @throws BizRuntimeException exception
     */
    ConsumerData findByAppAndPartnerUserId(String partnerUserId);
}
