package cn.com.duiba.creditsclub.ecosphere.sdk.utils;

import org.apache.http.Header;

import java.util.Map;

/**
 * 异步 Http 请求类
 */
public interface HttpAsyncClient {

    /**
     * 提交一个异步get请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param callback 异步回调函数
     */
    public void submitGet(String url, Map<String, String> params, HttpCallback callback);

    /**
     * 提交一个异步get请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param headers   请求头
     * @param callback 异步回调函数
     */
    public void submitGet(String url, Map<String, String> params, Header[] headers, HttpCallback callback);

    /**
     * 提交一个异步post请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param callback 异步回调函数
     */
    public void submitPost(String url, Map<String, String> params, HttpCallback callback);

    /**
     * 提交一个异步post请求(RAW串形式)
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param callback 异步回调函数
     */
    public void submitPostRaw(String url, Map<String, String> params, HttpCallback callback);

    /**
     * 提交一个异步post请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param headers   请求头
     * @param callback 异步回调函数
     */
    public void submitPost(String url, Map<String, String> params, Header[] headers, HttpCallback callback);

}
