package cn.com.duiba.creditsclub.ecosphere.sdk.utils;

import org.apache.http.Header;
import org.apache.http.HttpEntity;

import java.util.Map;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: HttpHelper.java , v 0.1 2019-11-26 13:41 ZhouFeng Exp $
 */
public interface HttpHelper {

    /**
     * 发起get请求
     *
     * @param url          请求地址
     * @param uriVariables 请求参数
     * @return
     */
    String doGet(String url, Map<String, String> uriVariables);

    /**
     * 发起get请求，并将结果JSON序列化
     * @param url 请求地址
     * @param uriVariables 请求参数
     * @param reponseType 结果对象
     * @param <T>
     * @return
     */
    <T> T doGet(String url, Map<String, String> uriVariables, Class<T> reponseType);

    /**
     * 发起get请求
     *
     * @param url          请求地址
     * @param uriVariables 请求参数
     * @param header       请求头
     * @return
     */
    String doGet(String url, Map<String, String> uriVariables, Header header);

    /**
     * 发起post请求，并将结果JSON序列化
     * @param url 请求地址
     * @param uriVariables 请求参数
     * @return
     */
    String doPost(String url, Map<String, String> uriVariables);

    /**
     * 发起post请求，并将结果JSON序列化
     * @param url 请求地址
     * @param uriVariables 请求参数
     * @param reponseType 结果对象
     * @param <T>
     * @return
     */
    <T> T doPost(String url, Map<String, String> uriVariables, Class<T> reponseType);

    /**
     * 发起post请求
     *
     * @param url        请求地址
     * @param header     请求头
     * @param httpEntity 请求体
     * @return
     */
    String doPost(String url, Header header, HttpEntity httpEntity);

}
